/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute;

import com.simibubi.create.content.logistics.item.filter.ItemAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2487;

public class BookAuthorAttribute
implements ItemAttribute {
    String author;

    public BookAuthorAttribute(String author) {
        this.author = author;
    }

    @Override
    public boolean appliesTo(class_1799 itemStack) {
        return this.extractAuthor(itemStack).equals(this.author);
    }

    @Override
    public List<ItemAttribute> listAttributesOf(class_1799 itemStack) {
        String name = this.extractAuthor(itemStack);
        ArrayList<ItemAttribute> atts = new ArrayList<ItemAttribute>();
        if (name.length() > 0) {
            atts.add(new BookAuthorAttribute(name));
        }
        return atts;
    }

    @Override
    public String getTranslationKey() {
        return "book_author";
    }

    @Override
    public Object[] getTranslationParameters() {
        return new Object[]{this.author};
    }

    @Override
    public void writeNBT(class_2487 nbt) {
        nbt.method_10582("author", this.author);
    }

    @Override
    public ItemAttribute readNBT(class_2487 nbt) {
        return new BookAuthorAttribute(nbt.method_10558("author"));
    }

    private String extractAuthor(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        if (nbt != null && nbt.method_10545("author")) {
            return nbt.method_10558("author");
        }
        return "";
    }
}

